function [Return] = Cholesky_Verfahren(aA,aB)
    %PRUEFUNG--------------------------------------------------------------------------
    iANZAHL_GLEICHUNGEN = size(aA,1);                                                   %Gibt die Anzahl an Zeilen zurck (Parameter 1)
    iANZAHL_WERTE = size(aA,2);                                                         %Gibt die Anzahl der Spalten zurck (Parameter 2)
    if(iANZAHL_GLEICHUNGEN<iANZAHL_WERTE)
       fprintf("Scotty, wir haben ein Problem!\n"); 
       fprintf("Es gibt weniger Gleichungen als Unbekannte!\n"); 
       return;                                                                          %Hoffe das beendet das Skript vorzeitig
    end
    if(issymmetric(aA))                                                                 %ist das gleiche wie if(aA==aA.')
       fprintf("Matrix ist symmetrisch\n");
    else
       fprintf("Scotty, wir haben ein Problem!\n");
       fprintf("Matrix ist nicht symmetrisch\n");
    end

    %R_ZERLEGUNG-----------------------------------------------------------------------
    aR=zeros(iANZAHL_GLEICHUNGEN,iANZAHL_WERTE);                                        %Initialisierung einer 0-Matrix
    for(i=1:1:iANZAHL_GLEICHUNGEN)
        for(j=i:1:iANZAHL_WERTE)                                                        %die Spalte j startet mit jedem Durchlauf bei dem Wert der Zeile i
            %Bearbeitung der Diagonal-Lmmel
            Zwischenspeicher=0;
            for(k=1:1:i-1)
                Zwischenspeicher=Zwischenspeicher+(aR(k,i)^2);
            end
            aR(i,i)=(aA(i,i)-Zwischenspeicher)^0.5;
            if((aA(i,i)-Zwischenspeicher) <= 0)
                fprintf("Matrix ist nicht positiv definit!\n");
                fprintf("Geprft an: R(%u,%u) = %f\n",i,i,(aA(i,i)-Zwischenspeicher));
                Return=Gauss_Verfahren(aA,aB);
                return;                                                                 %Ich hoffe das Programm bricht dadurch ab
            else
                fprintf("Postive Definitheit an Stelle: R(%u,%u) = %f erfolgreich geprft\n",i,i,(aA(i,i)-Zwischenspeicher));            
            end
            %Bearbeitung der Nicht-Diagnonal-Lmmel
            Zwischenspeicher = 0;
            for(k=1:1:i-1)
                Zwischenspeicher=Zwischenspeicher+(aR(k,i)*aR(k,j));
            end        
            aR(i,j)=(aA(i,j)-Zwischenspeicher)/aR(i,i);
        end
    end
    aRT=aR';                                                                            %Erzeugung der transponierten Matrix -> alternativ auch aRT=aR.';

    %VORWRTSAUFLSUNG-----------------------------------------------------------------
    for(i=1:1:iANZAHL_GLEICHUNGEN)
        Zwischenspeicher=0;
        for(j=1:1:i-1)
            Zwischenspeicher=Zwischenspeicher+(aRT(i,j)*aY(j));
        end
        aY(i)=(aB(i)-Zwischenspeicher)/aRT(i,i);
    end

    %RCKWRTSAUFLSUNG----------------------------------------------------------------
    for(i=iANZAHL_GLEICHUNGEN:-1:1)
        Zwischenspeicher=0;
        for(j=i+1:1:iANZAHL_WERTE)
            Zwischenspeicher=Zwischenspeicher+(aR(i,j)*aX(j));
        end
        aX(i)=(aY(i)-Zwischenspeicher)/aR(i,i);
    end
    aX=aX.';
    Return=aX(1:end);
end

